
var InsMsgData = (function ($) {
	return {
		MAX_UINT32: 0xffffffff,
		CookieUID: "uid",
		CookieSID: "sid",
		Login: "Login",
		LoginURL: "LoginUrl",
		SrvCenter: "SrvCenter",
		SrvNode: "SrvNode",
		Sys: "Sys",
		SysCfg: "SysCfg",
		DataUser: "DataU",
		DataUserT: "DataUT",
		DataOrg: "DataO",
		DataOrgT: "DataOT",
		Users: "Users",
		UsersT: "UsersT",
	}
})(jQuery);

var InsMsgApi = (function ($) {
	return {
		Download: "/Download",
		ClientUpdate: "/ClientUpdate",
		Login: "/Login",
		Logout: "/Logout",
		Reg: "/Reg",
		SysCfg: "/SysCfg",
		Online: "/Online",
		Pwd: "/Pwd",
		User: "/User",
		Org: "/Org",
		Uc: "/Uc",
		Group: "/Group",
		Session: "/Session",
		Msg: "/Msg",
		SysMsg: "/SysMsg",
		AddUsers: "/AddUsers",
		ListUser: "/List/User",
		ListOnline: "/List/Online",
		ListUc: "/List/Uc",
		ListGroup: "/List/Group",
		ListSysMsg: "/List/SysMsg",
	}
})(jQuery);

var InsMsgFun = (function ($) {
	return {
		V:function(v){
			if(v)return v;else return '';
		},
		TestEmail: function (eml) {
			var reg = /^[_a-zA-Z0-9]+@([_a-zA-Z0-9]+\.)+[a-zA-Z0-9]{2,5}$/;
			return reg.test(eml);
		},
		HtmlEncode: function (str) {
			return $("<textarea />").text(str).html();
		},
		HtmlDecode: function (str) {
			return $("<textarea />").html(str).text();
		},
		GetParameterByName: function (name, url) {
			if (!url) url = window.location.href;
			name = name.replace(/[\[\]]/g, "\\$&");
			var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
				results = regex.exec(url);
			if (!results) return null;
			if (!results[2]) return null;
			return decodeURIComponent(results[2].replace(/\+/g, " "));
		},
		GoLoginURL: function () {
			sessionStorage.removeItem(InsMsgData.SysCfg);

			var url = sessionStorage.getItem(InsMsgData.LoginURL);
			if (url == null) url = "/login.html";
			window.location.assign(url);
		},
		GetServerUrlRoot: function () {
			var vLogin = JSON.parse(sessionStorage.getItem(InsMsgData.Login));
			if (vLogin == null || vLogin.server == null || vLogin.port == null) return null;
			else return "https://" + vLogin.server + ":" + vLogin.port;
		},
		GetServerUrl: function (u) {
			var url = this.GetServerUrlRoot();
			if (url == null) return null;
			else return url + u;
		},
		_week_day: ["[日]", "[一]", "[二]", "[三]", "[四]", "[五]", "[六]"],
		WeekNum: function (ts) {
			var dt = new Date(ts * 1000);
			var b = new Date(dt.getFullYear(), 0, 1);
			var days = Math.floor((dt - b) / (24 * 60 * 60 * 1000));
			return Math.ceil((dt.getDay() + 1 + days) / 7);
		},
		TimeStr: function (ts) {
			var cur = new Date();
			var dt = new Date(ts * 1000);
			var stime = (dt.getHours() < 10) ? ("0" + dt.getHours().toString()) : dt.getHours().toString();
			stime += ":";
			stime += (dt.getMinutes() < 10) ? ("0" + dt.getMinutes().toString()) : dt.getMinutes().toString();
			var sdate = (dt.getMonth() < 10) ? ("0" + dt.getMonth().toString()) : dt.getMonth().toString();
			sdate += "-";
			sdate += (dt.getDate() < 10) ? ("0" + dt.getDate().toString()) : dt.getDate().toString();
			if (cur.getFullYear() == dt.getFullYear()) {
				if (cur.getMonth() == dt.getMonth()) {
					if (cur.getDate() == dt.getDate()) return stime;

					var wn = this.WeekNum(ts);
					if (this.WeekNum(cur.getTime() / 1000) == wn) {
						return this._week_day[dt.getDay()] + " " + stime;
					}
				}
				return sdate + this._week_day[dt.getDay()] + " " + stime;
			}
			return dt.getFullYear() + "-" + sdate + this._week_day[dt.getDay()] + " " + stime;
		},
		DlgClose: function (btn) {
			$("#" + btn.data('dlgid')).modal('hide');
		},
		DlgTimeout:function(){
			sessionStorage.removeItem(InsMsgData.UsersT);
			sessionStorage.removeItem(InsMsgData.Users);
			$("#Timeout").modal('toggle'); 
		},
		CookieUpdate: function () {
			var uid = $.cookie(InsMsgData.CookieUID);
			var sid = $.cookie(InsMsgData.CookieSID);
			if (uid == null || sid == null) return;

			var et = new Date();
			et.setTime(et.getTime() + 15 * 60 * 1000);
			$.cookie(InsMsgData.CookieUID, uid, { expires: et, path: '/' });
			$.cookie(InsMsgData.CookieSID, sid, { expires: et, path: '/' });
		},
		SDUserUpdate: function (t) {
			if (sessionStorage.getItem(InsMsgData.DataUserT) != t) sessionStorage.removeItem(InsMsgData.DataUserT);
			sessionStorage.setItem(InsMsgData.DataUserT, t);
		},
		HttpGet: function (url, fs, fe) {
			if(url==null || url.length<=0)return;
			$.ajax({
				url: url,
				method: "GET",
				beforeSend:function(xhr){
					xhr.withCredentials=true
				},
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				dataType: "json",
				cache: false,
				success: fs,
				error: fe
			});
		},
		HttpPost: function (url, jv, fs, fe) {
			if(url==null || url.length<=0)return;
			$.ajax({
				url: url,
				method: "POST",
				beforeSend:function(xhr){
					xhr.withCredentials=true
				},
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				data: JSON.stringify(jv),
				dataType: "json",
				cache: false,
				success: fs,
				error: fe
			});
		}
	}
})(jQuery);

